/******************************************************************************
 *
 *		7   S E G M E N T  M U X E D   D I S P L A Y   D R I V E R 
 *
 */
#include "display.h"
#include <math.h>	

#define SEG_G			0x01
#define SEG_DP			0x08

uchar seg1, seg2, seg3, seg4;
uchar currentdig, updating;

const uchar segtable[] ={
    //cdbepafg
    0b11110110, // 0
    0b10100000, // 1
    0b01110101, // 2
    0b11100101, // 3
    0b10100011, // 4
    0b11000111, // 5
    0b11010111, // 6
    0b10100100, // 7
    0b11110111, // 8
    0b10100111, // 9
    0b10110111, // A
    0b11010011, // B
    0b01010110, // C
    0b11110001, // D
    0b01010111, // E
    0b00010111, // F
};

void dispInitialise(void) {
    // Set up pins
    SEG_TRIS = 0xf00;
    LED1_TRIS = 0;
    LED2_TRIS = 0;
    LED3_TRIS = 0;
    LED4_TRIS = 0;

    // Configure Timer 0
    T1CONbits.RD16 = 1;                     // 16 bit reads
    T1CONbits.TMR1CS = 0;                   // Use System clock 4MHz
    T1CONbits.T1CKPS = 0;                   // No prescaler
    currentdig = 0;
    updating = 0;
    seg4 = 0;
    seg3 = 0;
    seg2 = 0;
    seg1 = 0;
    TMR1H = T1_RELOAD_HI;                   // Load timer
    TMR1L = T1_RELOAD_LO;
    T1CONbits.TMR1ON = 1;                   // Start timer
    IPR1bits.TMR1IP = 1;                    // T1 high priority
    PIR1bits.TMR1IF = 0;                    // Clear T1 int flag
    PIE1bits.TMR1IE = 1;                    // Allow T1 interrupts
}
//  Displays Hex digits
void dispHex(unsigned int hex) {
    updating = 1;
    seg4 = (uchar) (hex) & 0x0f;
    seg3 = (uchar) (hex >> 4) & 0x0f;
    seg2 = (uchar) (hex >> 8) & 0x0f;
    seg1 = (uchar) (hex >> 12) & 0x0f;
    updating = 0;
}
// Display Decimal
void dispDec(float num, uchar mode) {
    unsigned int dec;
    uchar neg;

    if (mode == 0) {
        if (num < 0.0 || num >= 999.95) {
            updating = 1;
            seg4 = SEG_G;
            seg3 = SEG_G;
            seg2 = SEG_G;
            seg1 = SEG_G;
            updating = 0;
            return;
        }
        dec = (unsigned int) (num * 10.0);
        updating = 1;
        seg4 = segtable[(uchar) (dec % 10)];
        dec /= 10;
        seg3 = segtable[(uchar) (dec % 10)] | SEG_DP;
        dec /= 10;
        seg2 = segtable[(uchar) (dec % 10)];
        dec /= 10;
        seg1 = segtable[(uchar) (dec % 10)];
        seg1 = seg1 == segtable[0] ? 0 : seg1;
        seg2 = seg2 == segtable[0] && seg1 == 0 ? 0 : seg2;
        updating = 0;
    } else if (mode == 1) {
        if (num < -99.95 || num > 99.95) {
            updating = 1;
            seg4 = SEG_G;
            seg3 = SEG_G;
            seg2 = SEG_G;
            seg1 = SEG_G;
            updating = 0;
            return;
        }
        neg = num < 0.0 ? 1 : 0;
        num = fabs(num);
        dec = (unsigned int) (num * 10.0);
        updating = 1;
        seg4 = segtable[(uchar) (dec % 10)];
        dec /= 10;
        seg3 = segtable[(uchar) (dec % 10)] | SEG_DP;
        dec /= 10;
        seg2 = segtable[(uchar) (dec % 10)];
        seg2 = seg2 == segtable[0] ? 0 : seg2;
        seg1 = neg ? SEG_G : 0;

        updating = 0;
    }
}

void dispDot(void) {
    seg1 = SEG_G; //-
    seg2 = SEG_G; //-
    seg3 = SEG_G; //-
    seg4 = SEG_G; //-
}

void dispBatt(void) {
    seg1 = SEG_DP; //-
    seg2 = 0; //-
    seg3 = 0; //-
    seg4 = 0; //-
}
// Turn Off display
void dispOff(void) {
    T1CONbits.TMR1ON = 0;
    PIE1bits.TMR1IE = 0; // disable timer0
    PIR1bits.TMR1IF = 0;
    SEGMENTS = 0x00;
    LED1 = 0;
    LED2 = 0;
    LED3 = 0;
    LED4 = 0;
}

void dispBlank(void) {
    seg1 = 0;
    seg2 = 0;
    seg3 = 0;
    seg4 = 0;
}

void dispOn(void) {
    TMR1H = T1_RELOAD_HI; // Load timer
    TMR1L = T1_RELOAD_LO;
    T1CONbits.TMR1ON = 1;
    PIR1bits.TMR1IF = 0;
    PIE1bits.TMR1IE = 1;
    currentdig = 0;
}
//  Displays segmnents in turn
void dispMux(void) {
    TMR1H = T1_RELOAD_HI; // Load timer
    TMR1L = T1_RELOAD_LO;
    if (updating == 0) {
        SEGMENTS = 0;
        switch (currentdig) {
            case 1:
            {
                LED1 = 0;
                currentdig = 2;
                SEGMENTS = seg2;
                LED2 = 1;
                break;
            }
            case 2:
            {
                LED2 = 0;
                currentdig = 3;
                SEGMENTS = seg3;
                LED3 = 1;
                break;
            }
            case 3:
            {
                LED3 = 0;
                currentdig = 4;
                SEGMENTS = seg4;
                LED4 = 1;
                break;
            }
            case 4:
            {
                LED4 = 0;
                currentdig = 1;
                SEGMENTS = seg1;
                LED1 = 1;
                break;
            }
            default:
            {
                LED1 = 0;
                LED2 = 0;
                LED3 = 0;
                LED4 = 0;
                currentdig = 1;
                SEGMENTS = seg1;
                LED1 = 1;
                break;
            }
        }
    }
}	